function logthetaf=logthetadensity(xf,y,wconf,betaconft,clusteralloct,ict)
% This function calculates the full conditional density of theta

logthetaf=zeros(1,size(xf,2));
for ixf=1:size(xf,2)
prior=normpdf(xf(ixf),0,1.8); % this gives (almost) flat density from 0 to 1
vectorforsum=(y(clusteralloct==ict)'.*((xf(ixf)+betaconft'*wconf(clusteralloct==ict,:)')-log(1+exp(xf(ixf)+betaconft'*wconf(clusteralloct==ict,:)'))))...
    +((1-y(clusteralloct==ict)').*(-log(1+exp(xf(ixf)+betaconft'*wconf(clusteralloct==ict,:)'))));
logthetaf(ixf)=sum(vectorforsum)+log(prior);

end